/* playdvd.c 
 *
 * Copyright (C) 1999 LinuxDVD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>
#include <linux/cdrom.h>
#include <linux/videodev.h>
#include <linux/fs.h>
#include <endian.h>

int videofd;
int f, delay = 0;
#define DO_DELAY 406800

unsigned char inbuf[2048];
unsigned char fluff[32768];
unsigned char dlybuf[406800];
unsigned char sequence_error[4] = { 0x00, 0x00, 0x01, 0xb4 };

#define dump_current(a) \
	fprintf(stderr, "%02x %02x %02x %02x %02x %02x %02x %02x " \
		"%02x %02x %02x %02x %02x %02x %02x %02x\n", \
		a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], \
		a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15]);

#if 0
static lastwritemode = VID_WRITE_MPEG_VID;
void decodedata(unsigned char *buf, int length, int mode)
{
#ifdef DO_DELAY
	if (mode == VID_WRITE_MPEG_VID) {
		if (delay < DO_DELAY) {
			memcpy(dlybuf + delay, buf, length);
			delay += length;
			return;
		} else {
			ioctl(videofd, VIDIOCSWRITEMODE, &mode);
			write(videofd, dlybuf, delay);
			memcpy(dlybuf, buf, length);
			delay = length;
			return;
		}
	}
#endif
	if (mode != lastwritemode) {
		ioctl(videofd, VIDIOCSWRITEMODE, &mode);
		lastwritemode = mode;
	}
	write(videofd, buf, length);
}
#endif

#if BYTE_ORDER == BIG_ENDIAN
#define BLOCK_START_CODE	0x000001ba
#define BLOCK_CRYPT_MASK	0x30000000
#define VID_START_MASK		0xfff0ffff
#define AUD_START_MASK		0xffe0ffff
#define VID_DETECT_BYTES	0x01e007ec
#define AUD_DETECT_BYTES	0x01c007ec
#define AC3_DETECT_BYTES	0x01bd07ec
#else
#define BLOCK_START_CODE	0xba010000
#define BLOCK_CRYPT_MASK	0x00000030
#define VID_START_MASK		0xfffff0ff
#define AUD_START_MASK		0xffffe0ff
#define VID_DETECT_BYTES	0xec07e001
#define AUD_DETECT_BYTES	0xec07c001
#define AC3_DETECT_BYTES	0xec07bd01
#endif

void parsedvd(char *key, int audiotrack)
{
	int i;
	__u32 *wordbuf = (__u32 *) inbuf;
	while (read(f, inbuf, 2048) == 2048) {
		if (wordbuf[0x00] != BLOCK_START_CODE)
			continue;
		if (wordbuf[0x04] == AC3_DETECT_BYTES) {
			if (wordbuf[0x05] & BLOCK_CRYPT_MASK)
				decipher_sector(inbuf, key);
			i = inbuf[0x16] + 27;
			if (inbuf[i - 4] == (0x80|(audiotrack & 0x07)))
				write(fileno(stdout), &inbuf[i], 2048 - i);
		} else if ((wordbuf[0x04] & VID_START_MASK) ==
			VID_DETECT_BYTES) {
#if 0
			if (wordbuf[0x05] & BLOCK_CRYPT_MASK)
				decipher_sector(inbuf, key);
			decodedata(&inbuf[0x0e], 2034, VID_WRITE_MPEG_VID);
#endif
		} else if ((wordbuf[0x04] & AUD_START_MASK) ==
			AUD_DETECT_BYTES) {
#if 0
			if (wordbuf[0x05] & BLOCK_CRYPT_MASK)
				decipher_sector(inbuf, key);
			decodedata(&inbuf[0x0e], 2034, VID_WRITE_MPEG_AUD);
#endif
		}
	}
}

int encryption_status(int fd)
{
        dvd_struct d;

        d.copyright.type = DVD_STRUCT_COPYRIGHT;
        d.copyright.layer_num = 0;

        if (ioctl(fd, DVD_READ_STRUCT, &d)<0) {
                perror("DVD_READ_STRUCT");
                return 0;
        }
        if (!d.copyright.cpst) {
                fprintf(stderr, "Disc is not encrypted.\n");
		return 0;
	}
	return 1;
}

int dvd_auth(int fd, int agid, int step, char *buffer, int lba)
{
	dvd_authinfo ai;
	int i;

	memset(&ai, 0, sizeof(ai));
	ai.lsa.agid = agid;

	if (step == DVD_LU_SEND_AGID) {
		for (i = 0; i < 4; i++) {
			ai.type = DVD_INVALIDATE_AGID;
			ai.lsasf.agid = i;
			ioctl(fd, DVD_AUTH, &ai);
		}
		ai.type = DVD_LU_SEND_AGID;
	} else if (step == DVD_HOST_SEND_CHALLENGE) {
		ai.type = DVD_HOST_SEND_CHALLENGE;
		for (i = 0; i < 10; i++)
			ai.hsc.chal[9 - i] = buffer[i];
	} else if (step == DVD_LU_SEND_KEY1) {
		ai.type = DVD_LU_SEND_KEY1;
	} else if (step == DVD_LU_SEND_CHALLENGE) {
		ai.type = DVD_LU_SEND_CHALLENGE;
	} else if (step == DVD_HOST_SEND_KEY2) {
		ai.type = DVD_HOST_SEND_KEY2;
		for (i = 0; i < 5; i++)
			ai.hsk.key2[4 - i] = buffer[i];
	} else if (step == 2048) {
		dvd_struct s;
		s.type = DVD_STRUCT_DISCKEY;
		s.disckey.agid = agid;
		if (ioctl(fd, DVD_READ_STRUCT, &s) < 0)
			return -1;
		memcpy(buffer, s.disckey.value, 2048);
		return 0;
	} else if (step == DVD_LU_SEND_TITLE_KEY) {
		ai.type = DVD_LU_SEND_TITLE_KEY;
		ai.lstk.lba = lba;
	} else
		return -1;
	if (ioctl(fd, DVD_AUTH, &ai) < 0)
		return -1;
	if (step == DVD_LU_SEND_AGID)
		return ai.lsa.agid;
	if (step == DVD_LU_SEND_KEY1) {
		for (i = 0; i < 5; i++)
			buffer[i] = ai.lsk.key1[4 - i];
	}
	if (step == DVD_LU_SEND_CHALLENGE) {
		for (i = 0; i < 10; i++)
			buffer[i] = ai.hsc.chal[9 - i];
	}
	if (step == DVD_LU_SEND_TITLE_KEY) {
		for (i = 0; i < 5; i++)
			buffer[i] = ai.lstk.title_key[i];
	}
	return 0;
}

int main(int argc, char **argv)
{
	int d = 0, s = 0, fd, lba, agid;
	unsigned char outf[25], finalkey[5];
#if 0
	struct play_mode p;
#endif
	int drive_index, dowhat, index;
	static unsigned char Challenge[10], Key1[5], Key2[5];
	static unsigned char DiscKey[2048], BusKey[5];

	if (argc < 3) {
		fprintf(stderr,
			"usage: %s mpegfile device [dopal]\n", argv[0]);
		exit(1);
	}
	if ((f = open(argv[1], O_RDONLY)) < 0) {
		perror(argv[1]);
		exit(1);
	}
	d = atoi(argv[2]);
	if (argc > 3)
		s = atoi(argv[3]);
	fd = open("/dev/cdrom", O_RDONLY);
        if (!encryption_status(fd))
                goto noauth;
	lba = 0;
	if (ioctl(f, FIBMAP &lba) < 0)
		lba = 730410;
	srand(time(NULL));
	for (index = 0; index < 10; index++)
		Challenge[index] = rand() & 0xff;

	for (dowhat = 0; dowhat < 2; dowhat++) {
		if ((agid = dvd_auth(fd, 0, DVD_LU_SEND_AGID, NULL, lba)) < 0)
			goto badauth;
		if (dvd_auth(fd, agid,
			DVD_HOST_SEND_CHALLENGE, Challenge, lba))
			goto badauth;
		if (dvd_auth(fd, agid, DVD_LU_SEND_KEY1, Key1, lba))
			goto badauth;
		for (drive_index = -1, index = 0; index < 32; index++) {
			CryptKey1(index, Challenge, Key2);
			if (memcmp(Key2, Key1, 5) == 0) {
				drive_index = index;
				break;
			}
		}
		if (drive_index < 0)
			goto badauth;
		if (dvd_auth(fd, agid, DVD_LU_SEND_CHALLENGE, Challenge, lba))
			goto badauth;
		CryptKey2(drive_index, Challenge, Key2);
		if (dvd_auth(fd, agid, DVD_HOST_SEND_KEY2, Key2, lba))
			goto badauth;
		memcpy(Challenge, Key1, 5);
		memcpy(Challenge + 5, Key2, 5);
		CryptBusKey(drive_index, Challenge, BusKey);
		if (dowhat == 0) {
			if (dvd_auth(fd, agid, 2048, DiscKey, lba))
				goto badauth;
			for (index = 0; index < 2048; index++)
				DiscKey[index] ^= BusKey[4 - (index % 5)];
		} else {
			if (dvd_auth(fd, agid,
				DVD_LU_SEND_TITLE_KEY, Key1, lba))
				goto badauth;
			for (index = 0; index < 5; index++)
				Key1[index] ^= BusKey[4 - index];
		}
	}
	generate_decryption_key(DiscKey, Key1, finalkey);
	fprintf(stderr,"Final Key: %02x%02x%02x%02x%02x\n", finalkey[0],
		finalkey[1], finalkey[2], finalkey[3], finalkey[4]);
noauth:
	memset(fluff, 0x00, 32768);
	memcpy(fluff, sequence_error, 4);
#if 0
	sprintf(outf, "/dev/video%d", d);
#else
	sprintf(outf, "/dev/null");
#endif
	if ((videofd = open(outf, O_RDWR)) < 0) {
		perror(outf);
		exit(1);
	}
#if 0
	p.mode = VID_PLAY_VID_OUT_MODE;
	p.p1 = VIDEO_MODE_NTSC;
	if (s == 1)
		p.p1 = VIDEO_MODE_PAL;
	ioctl(videofd, VIDIOCSPLAYMODE, &p);
#endif
	parsedvd(finalkey, 0);
	/* flush buffers */
#if 0
	decodedata(fluff, 4096, VID_WRITE_MPEG_AUD);
	decodedata(fluff, 32768, VID_WRITE_MPEG_VID);
#endif
	close(f);
	exit(0);
badauth:
	fprintf(stderr, "DVD Authentication Failed...\n");
	exit(1);
}				/* main */
